	function [G, Z, R_ZEROS, P, Ws] = BW_CONST_R_POLES_S(Wc, Ws, Amin, N)	
	
	% 	Computes the denormalized poles, zeros and gain constant for  
	%	an analog lowpass Butterworth filter with constant pole radius.  
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB 
	
	% 	Author: 		Lars Wanhammar, 1999-9-27
    % 	Modified by: 	  
	% 	Version: 		1
	% 	Known bugs:		
	% 	Report bugs to:	Wanhammar@gmail.com
	
	x = 10^(0.1*Amin);
	Amax0 = 10*log10(x/(x-1));
	if Amax0 < Amax
		Amax = Amax0;
	end	
	[G, Z, P] = BW_POLES_S(Wc, Ws, Amax, Amin, N);
	
